//Version 1.0.0
var formatedTotalTime,
    firstLoaded = false,
    presSettings = {},
    Presentation,
    isTouchDevice,
    ipadKeyPadFlg,
    isPlaying = false;

window.onload = function() {
	if (!(document.createElement('canvas').getContext)) {
		document.getElementById('resizer').innerHTML = '';
		document.getElementById('toolbar').innerHTML = '';
		document.getElementById('toolbar').style.width = '0px';
		document.write('Oops! Your browser does not support HTML5. You need to upgrade your browser to view this content.');
		return;
	}
	//initialize presentation.
	Presentation = new DopPresentation(new eventsHandler);
	Presentation.SetRPath("data/");
	try {
		document.createEvent('TouchEvent');
		isTouchDevice = true;
	} catch(err) {
		isTouchDevice = false;
	}
	Presentation.LoadPres('pres', 1);
};
//use this to handle events
var eventsHandler = function() {
	this.OnLoadingStart = function() {
		loading.LoadingStart();
	};
	this.OnLoadingEnd = function() {
		loading.LoadingEnd();
	};
	this.OnSlideChange = function(slideNo) {
		pcc.HandleSlideChange(slideNo);
	};
	this.OnMovToNxtAnim = function() {
		//handle nxt animation
	};
	this.OnMovToPrvAnim = function() {
		//handle nxt animation
	};
	this.OnPlayingStart = function() {
		isPlaying = true;
		pcc.HandlePlayAndPause(true);
	};
	this.OnPlayingEnd = function() {
		isPlaying = false;
		pcc.HandlePlayAndPause(false);
	};
	this.OnProgressChange = function(t) {
		pcc.HandleProgress(t);
	};
	this.InitaliseSettings = function(o) {
		presSettings = o;
		AtInit();
	};
};
function AtInit()
{
    var objResizer = document.getElementById('resizer');

    objResizer.style.height = presSettings.Height + 'px';
    objResizer.style.width = presSettings.Width + 'px';
	
	document.getElementsByTagName('body')[0].style.backgroundColor = presSettings.BackColr;
    
    var objContentHolder = document.getElementById('contentHolder');
    objContentHolder.style.height = presSettings.Height + 'px';
    objContentHolder.style.width = presSettings.Width + 'px';
    
    var s = Math.floor((presSettings.TotalTime / 1000) % 60);
    var m = Math.floor(((presSettings.TotalTime / 1000) / 60) % 60);
    var h = Math.floor((((presSettings.TotalTime / 1000) / 60) / 60) % 24);

    if (s < 10) {
    	s = "0" + s;
    }
	if (m < 10) {
		m = "0" + m;
	}
	if (h < 10) {
		h = "0" + h;
	}
	if (h == 0) {
		formatedTotalTime = m + ":" + s;
	} else {
		formatedTotalTime = +h + ":" + m + ":" + s;
	}
}

var loading =
	(
		function() {

			function loadingStart() {
				//Handle Loading start here
				document.getElementById('preloader').style.display = 'block';
			};

			function loadingEnd() {
				//Handle Loading end here
				document.getElementById('preloader').style.display = 'none';

				if (!firstLoaded) {
					firstLoaded = true;

					document.getElementById('btnPrev').onclick = Presentation.Prev;
					document.getElementById('btnPause').onclick = Presentation.Pause;
					document.getElementById('btnPlay').onclick = Presentation.Play;
					document.getElementById('btnNext').onclick = Presentation.Next;

					document.getElementById('btnNxtSlide').onclick = Presentation.NxtSlide;
					document.getElementById('btnPrvSlide').onclick = Presentation.PrvSlide;

					document.getElementById('btnGoto').onclick = pcc.HandleGoto;

					document.getElementById('resizer').onclick = Presentation.Next;
				}
			};
			return {
				'LoadingStart': loadingStart,
				'LoadingEnd': loadingEnd
			};
		}
	)();
PlayerControlClass = function() {
	this.HandlePlayAndPause = function(f) {
		//Handle play pause here
		
		if (f) {
			document.getElementById('btnPause').style.display = 'block';
			document.getElementById('btnPlay').style.display = 'none';
		} else {
			document.getElementById('btnPause').style.display = 'none';
			document.getElementById('btnPlay').style.display = 'block';
		}
	};
	this.HandleSlideChange = function(n) {
		//Handle slide change here
		
		var objSlideNumberDiv = document.getElementById('SlideNumberDiv');
		objSlideNumberDiv.innerHTML = n + '/' + presSettings.TotalSlides;
	};
	this.HandleProgress = function(t) {
		//Handle presentation progress here


		var ratio = 300 / presSettings.TotalTime;
		var width = t * ratio;
		document.getElementById('ProgressBarDiv').style.width = width + 'px';

		var s = Math.floor((t / 1000) % 60);
		var m = Math.floor(((t / 1000) / 60) % 60);
		var h = Math.floor((((t / 1000) / 60) / 60) % 24);

		if (s < 10)
			s = "0" + s;

		if (m < 10)
			m = "0" + m;

		if (h < 10)
			h = "0" + h;

		if (h == "00")
			document.getElementById('time').innerHTML = m + ":" + s + '/' + formatedTotalTime;
		else
			document.getElementById('time').innerHTML = h + ":" + m + ":" + s + '/' + formatedTotalTime;
	};
	this.HandleGoto = function() {
		var v = document.getElementById('inputGoto').value;
		var n = parseInt(v);

		if (n == isNaN)
			return;
		Presentation.GotoSlide(n);
	};
};
pcc = new PlayerControlClass();